<?php
session_start();
error_reporting(0);
include('includes/config.php');
if(strlen($_SESSION['alogin'])=="")
    {   
    header("Location: index.php"); 
    }
    else{
        ?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
    	<meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Automatic Weather Station System | Dashboard</title>
        <link rel="stylesheet" href="css/bootstrap.min.css" media="screen" >
        <link rel="stylesheet" href="css/font-awesome.min.css" media="screen" >
        <link rel="stylesheet" href="css/animate-css/animate.min.css" media="screen" >
        <link rel="stylesheet" href="css/lobipanel/lobipanel.min.css" media="screen" >
        <link rel="stylesheet" href="css/toastr/toastr.min.css" media="screen" >
        <link rel="stylesheet" href="css/icheck/skins/line/blue.css" >
        <link rel="stylesheet" href="css/icheck/skins/line/red.css" >
        <link rel="stylesheet" href="css/icheck/skins/line/green.css" >
        <link rel="stylesheet" href="css/main.css" media="screen" >
         <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.0.0/animate.min.css" />
    	<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
        <script src="js/modernizr/modernizr.min.js"></script>
        <!--<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.0/css/all.min.css" />-->
        <style>
        

        /*.ele {*/
        /*     animation-duration: 60s;*/
        /*}*/
        .card {
          /* Add shadows to create the "card" effect */
          width:16%;
          box-shadow: 0 15px 15px 0 rgba(0,0,0,0.2);
          transition: 0.3s;
          float:left;
          background:#FFF;
          margin:4px;
          height:148px;
          position:relative;
          border-radius:10px;
          border:1px solid black;
          
        }
        
        .ravg {
            position: relative;
            margin: auto;
            top: 20px;
            font-size: x-large;
            display: table;
        }
        
          .ravg2 {
            position: relative;
            margin: auto;
        
            text-align: center;
            font-size: 50px;
            font-weight: bolder;
            padding: 28px 20px;
        }
        
        .rfoot {
            position: relative;
            display: block;
            margin: inherit;
            top: 29px;
            font-size: small;
            color: orange;
        }
        /* On mouse-over, add a deeper shadow */
        .card:hover {
          box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
        }
        
        /* Add some padding inside the card container */
        .container {
          padding: 2px 16px;
        }

        
        </style>
         
    </head>
  
    <body class="top-navbar-fixed">
        <div class="main-wrapper">
              <?php include('includes/topbar.php');?>
            <div class="content-wrapper">
                <div class="content-container">

                    

                    <div class="main-page">
                        <div class="container-fluid">
                            <div class="row page-title-div">
                                <div class="col-sm-6">
                                    <h2 class="title">Dashboard</h2>
                                  
                                </div>
                                <!-- /.col-sm-6 -->
                            </div>
                            <!-- /.row -->
                            <div class="row breadcrumb-div">
                                <div class="col-md-6">
                                    <ul class="breadcrumb">
            							<li><a href="dashboard.php"><i class="fa fa-home"></i> Home</a></li>
            						
            							<li class="active">Latest Record AWS</li>
            						</ul>
                                </div>
                               
                            </div>
                            <!-- /.row -->
                            <!-- /.row -->
                      
                        </div>
                        <!-- /.container-fluid -->

                        <section class="section">
                            <div class="container-fluid">
				                <div class="row">
				                    
				                    <div class="col-md-12">
				                        
				                      <div class="col-sm-4" >
				                        <div class="panel panel-default" style="background: antiquewhite;border-radius:10px; box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
                                            <!--<div class="panel-heading text-center" style="background: antiquewhite;"><strong> BP (mBar) </strong></div>-->
                                            <div class="panel-body" style="background: #b2ddb4; ">
                                                 <strong class="pull-right badge" style="background:#81c784;color:#000;"> TEMP (DegC) </strong>
                                            <div  
                                                class="row ravg2" style=""><img class="animate__animated animate__shakeX ele" style="height:64px;width:64px;" src="https://img.icons8.com/wired/64/000000/temperature.png"/> &nbsp;
                                               
                                                <span  id="tavg"> 23 </span>
                                            </div>    
                                            <p style="text-align: center" id="ttime"> <i class="fa fa-clock-o"></i> Updating... </p>
                                        
                                            </div>
                                            <div class="panel-footer" style="padding:40px;background:#81c784">
                                                 <span class="pull-left" style="font-weight:bolder;font-size:18px;"  id="tmin" >Min: 12</span>
                                                <!--<div class="text-center">Avg: </div>-->
                                                <span class="pull-right" style="font-weight:bolder;font-size:18px;"  id="tmax" >Max: 14 </span>
                                            
                                            </div>
                                        </div>
                                
                                     </div>
                                     
                                     
                                    <div class="col-sm-4" >
				                        <div class="panel panel-default" style="background: antiquewhite;border-radius:10px; box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
                                            <!--<div class="panel-heading text-center" style="background: antiquewhite;"><strong> BP (mBar) </strong></div>-->
                                            <div class="panel-body" style="background: #d8d835; ">
                                                 <strong class="pull-right badge" style="background:#ffff66;color:#000;"> HUMIDITY (%) </strong>
                                            <div  
                                                class="row ravg2" style=""><img class="animate__animated animate__shakeX ele" style="height:64px;width:64px;" src="https://img.icons8.com/wired/64/000000/humidity.png"/> &nbsp;
                                               
                                                <span  id="rhavg"> 23 </span>
                                            </div>    
                                            <p style="text-align: center" id="wstime"> <i class="fa fa-clock-o"></i> Updating... </p>
                                        
                                            </div>
                                            <div class="panel-footer" style="padding:40px;background:#ffff66">
                                                 <span class="pull-left" style="font-weight:bolder;font-size:18px;"  id="rhmin" >Min: 12</span>
                                                <!--<div class="text-center">Avg: </div>-->
                                                <span class="pull-right" style="font-weight:bolder;font-size:18px;"  id="rhmax" >Max: 14 </span>
                                            
                                            </div>
                                        </div>
                                
                                     </div>
                                     
                                    <div class="col-sm-4" >
				                        <div class="panel panel-default" style="background: antiquewhite;border-radius:10px; box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
                                            <!--<div class="panel-heading text-center" style="background: antiquewhite;"><strong> BP (mBar) </strong></div>-->
                                            <div class="panel-body" style="background: #fbe4e3; ">
                                                 <strong class="pull-right badge" style="background:#f9c1c0;color:#000;"> WIND SPEED (Km/h) </strong>
                                            <div  
                                                class="row ravg2" style=""><img class="animate__animated animate__shakeX ele" style="height:64px;width:64px;" src="https://img.icons8.com/pastel-glyph/64/000000/wind--v1.png"/> &nbsp;
                                               
                                                <span  id="wsavg"> 23 </span>
                                            </div>    
                                            <p style="text-align: center" id="wsstime"> <i class="fa fa-clock-o"></i> Updating... </p>
                                        
                                            </div>
                                            <div class="panel-footer" style="padding:40px;background:#f9c1c0">
                                                 <span class="pull-left" style="font-weight:bolder;font-size:18px;"  id="wsmin" >Min: 12</span>
                                                <!--<div class="text-center">Avg: </div>-->
                                                <span class="pull-right" style="font-weight:bolder;font-size:18px;"  id="wsmax" >Max: 14 </span>
                                            
                                            </div>
                                        </div>
                                
                                     </div>
                                     
                                    <div class="col-sm-4" >
				                        <div class="panel panel-default" style="background: antiquewhite;border-radius:10px; box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
                                            <!--<div class="panel-heading text-center" style="background: antiquewhite;"><strong> BP (mBar) </strong></div>-->
                                            <div class="panel-body" style="background: #fce5b7; ">
                                                 <strong class="pull-right badge" style="background:#f9d486;color:#000;"> WIND DIR(Deg) </strong>
                                            <div  
                                                class="row ravg2" style=""><img class="animate__animated animate__shakeX ele" style="height:64px;width:64px;" src="https://ultratech.serrax.io/images/final_wd_logo-removebg-preview.png" /> &nbsp;
                                               
                                                <span  id="wdavg"> 23 </span>
                                            </div>    
                                            <p style="text-align: center" id="wdtime"> <i class="fa fa-clock-o"></i> Updating... </p>
                                        
                                            </div>
                                            <div class="panel-footer" style="padding:40px;background:#f9d486">
                                                 <span class="pull-left" style="font-weight:bolder;font-size:18px;"  id="wsmin" ></span>
                                                <!--<div class="text-center">Avg: </div>-->
                                                <span class="pull-right" style="font-weight:bolder;font-size:18px;"  id="wsmax" ></span>
                                            
                                            </div>
                                        </div>
                                
                                     </div>
                                     
				                        
				                    
				                        
				                      <div class="col-sm-4" >
				                        <div class="panel panel-default" style="background: antiquewhite;border-radius:10px; box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
                                            <!--<div class="panel-heading text-center" style="background: antiquewhite;"><strong> BP (mBar) </strong></div>-->
                                            <div class="panel-body" style="background: #b1ccf0; ">
                                                 <strong class="pull-right badge" style="background:#86b0e8;color:#000;"> RAIN (mm) </strong>
                                            <div  
                                                class="row ravg2" style=""><img class="animate__animated animate__shakeX ele" style="height:64px;width:64px;" src="https://img.icons8.com/wired/64/000000/rain.png"/> &nbsp;
                                               
                                                <span  id="pavg"> 23 </span>
                                            </div>    
                                            <p style="text-align: center" id="stime"> <i class="fa fa-clock-o"></i> Updating...</p>
                                        
                                            </div>
                                            <div class="panel-footer" style="padding:40px;background:#86b0e8">
                                                 <span class="pull-left" style="font-weight:bolder;font-size:18px;"  id="min" ></span>
                                                <!--<div class="text-center">Avg: </div>-->
                                                <span class="pull-right" style="font-weight:bolder;font-size:18px;"  id="max" ></span>
                                            
                                            </div>
                                        </div>
                                
                                     </div>
                                     
				                    
                                    
                 
                                  
                                    
                                        <div class="col-sm-4" >
				                        <div class="panel panel-default" style="background: antiquewhite;border-radius:10px; box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
                                            <!--<div class="panel-heading text-center" style="background: antiquewhite;"><strong> BP (mBar) </strong></div>-->
                                            <div class="panel-body" style="background: #fce5b7; ">
                                                 <strong class="pull-right badge" style="background:#f9d486;color:#000;"> SOLAR (watt/m2) </strong>
                                            <div  
                                                class="row ravg2" style=""><img class="animate__animated animate__shakeX ele" style="height:64px;width:64px;" src="https://img.icons8.com/wired/64/000000/sun.png"/> &nbsp;
                                               
                                                <span  id="savg"> 23 </span>
                                            </div>    
                                            <p style="text-align: center" id="time"> <i class="fa fa-clock-o"></i> Updating... </p>
                                        
                                            </div>
                                            <div class="panel-footer" style="padding:40px;background:#f9d486">
                                                 <span class="pull-left" style="font-weight:bolder;font-size:18px;"  id="smin" ></span>
                                                <!--<div class="text-center">Avg: </div>-->
                                                <span class="pull-right" style="font-weight:bolder;font-size:18px;"  id="smax" ></span>
                                            
                                            </div>
                                        </div>
                                
                                     </div>
                                   
                                       <div class="col-sm-4" >
				                        <div class="panel panel-default" style="background: antiquewhite;border-radius:10px; box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
                                            <!--<div class="panel-heading text-center" style="background: antiquewhite;"><strong> BP (mBar) </strong></div>-->
                                            <div class="panel-body" style="background: #fbe4e3; ">
                                                 <strong class="pull-right badge" style="background:#f9c1c0;color:#000;"> BP (mbar) </strong>
                                            <div  
                                                class="row ravg2" style=""><img class="animate__animated animate__shakeX ele" style="height:64px;width:64px;" src="https://img.icons8.com/ios/50/000000/atmospheric-pressure.png"/> &nbsp;
                                               
                                                <span  id="bpavg"> 0 </span>
                                            </div>    
                                            <p style="text-align: center" id="bptime"> <i class="fa fa-clock-o"></i> Updating... </p>
                                        
                                            </div>
                                            <div class="panel-footer" style="padding:40px;background:#f9c1c0">
                                                 <span class="pull-left" style="font-weight:bolder;font-size:18px;"  id="bpmin" ></span>
                                                <!--<div class="text-center">Avg: </div>-->
                                                <span class="pull-right" style="font-weight:bolder;font-size:18px;"  id="bpmax" ></span>
                                            
                                            </div>
                                        </div>
                                
                                     </div>
                                    
                                    
                                     <div class="col-sm-4" >
				                        <div class="panel panel-default" style="background: antiquewhite;border-radius:10px; box-shadow: rgba(0, 0, 0, 0.25) 0px 54px 55px, rgba(0, 0, 0, 0.12) 0px -12px 30px, rgba(0, 0, 0, 0.12) 0px 4px 6px, rgba(0, 0, 0, 0.17) 0px 12px 13px, rgba(0, 0, 0, 0.09) 0px -3px 5px;">
                                            <!--<div class="panel-heading text-center" style="background: antiquewhite;"><strong> BP (mBar) </strong></div>-->
                                            <div class="panel-body" style="background: #fbe4e3; ">
                                                 <strong class="pull-right badge" style="background:#f9c1c0;color:#000;"> Battery (Volts) </strong>
                                            <div  
                                                class="row ravg2" style=""><img class="animate__animated animate__shakeX ele" style="height:64px;width:64px;" src="https://img.icons8.com/ios-glyphs/90/000000/battery--v1.png" /> &nbsp;
                                               
                                                <span  id="volts"> 23 </span>
                                            </div>    
                                            <p style="text-align: center" id="battr"> <i class="fa fa-clock-o"></i> Updating... </p>
                                        
                                            </div>
                                            <div class="panel-footer" style="padding:40px;background:#f9c1c0">
                                                 <span class="pull-left" style="font-weight:bolder;font-size:18px;"   ></span>
                                                <!--<div class="text-center">Avg: </div>-->
                                                <span class="pull-right" style="font-weight:bolder;font-size:18px;"   > </span>
                                            
                                            </div>
                                        </div>
                                    </div>
                                    
                                    
                                     
                                                        
                                  
                                     
                                     
                                     
				                  </div>
				                </div>
				                
				                
			            	    
                           
                            </div>
                            <br/>
                            <hr/ style="color:orange;">
                            
                             <div class="container-fluid">
				                <div class="row">
				                     <div class="col-md-12" style="margin-bottom: 40px;"><a href="detailReport.php" class="btn btn-primary mt-1 pull-right" > Detailed Report </a></div>
				                     <div class="col-sm-12">
				                          <div class="panel panel-warning" >
				                            <div class="panel-heading" style="padding:17px;"> <h3 class="panel-title"> Wind Speed (km/h) </h3></div>  
				                           <div class="panel-body">
				                                <div id='wind'><!-- Plotly chart wind speed will be drawn inside this DIV </div--></div>
				                            </div>
				                         </div>
                                     
				                    </div>
				                     <div class="col-sm-12">
				                          <div class="panel panel-warning" >
				                            <div class="panel-heading" style="padding:17px;"> <h3 class="panel-title"> Rain(MM)  </h3></div>  
				                           <div class="panel-body">
				                                <div id='rain'><!-- Plotly rain chart will be drawn inside this DIV </div--></div>
				                            </div>
				                         </div>
				                        
                                     
				                    </div>
				                </div>
				                
				                <br/>
				                <div class="row">
				                    
				                     <div class="col-sm-12">
				                         
				                        <div class="panel panel-warning" >
				                            <div class="panel-heading" style="padding:17px;"> <h3 class="panel-title"> HUMIDITY(%)  </h3></div>  
				                           <div class="panel-body">
				                                <div id='humid'><!-- Plotly humid chart will be drawn inside this DIV </div--></div>
				                            </div>
				                         </div>
				                        
                                     
				                    </div>
				                    
				                     <div class="col-sm-12">
				                        <div class="panel panel-warning" >
				                            <div class="panel-heading" style="padding:17px;"> <h3 class="panel-title"> Solar (watt/m2)  </h3></div>  
				                           <div class="panel-body">
                                                <div id='solar'>
				                            </div>
				                         </div>
				                        
				                       
                                     
				                    </div>
				                </div>
				                
				                <br/>
				                <div class="row">
				                     <div class="col-md-12">
				                        <div class="panel panel-warning" >
				                           <div class="panel-heading" style="padding:17px;"> <h3 class="panel-title">BP (mbar)  </h3></div>  
				                           <div class="panel-body">
                                                 <div id='bp'>
				                            </div>
				                         </div>
				                       
                                     
				                    </div>
				                    
				                     <div class="col-md-12">
				                          <div class="panel panel-warning" >
				                           <div class="panel-heading" style="padding:17px;"> <h3 class="panel-title"> AT(DegC)  </h3></div>  
				                           <div class="panel-body">
                                                  <div id='temp'><!-- Plotly temp chart will be drawn inside this DIV </div--></div>
				                            </div>
				                         </div>
				                      
				                    </div>
				                    
				                    <div class="col-md-12">
				                          <div class="panel panel-warning" >
				                           <div class="panel-heading" style="padding:17px;"> <h3 class="panel-title"> DIRECTION(Deg)  </h3></div>  
				                           <div class="panel-body">
                                                  <div id='wdir'><!-- Plotly temp chart will be drawn inside this DIV </div--></div>
				                            </div>
				                         </div>
				                      
				                    </div>
				                    
				                      <div class="col-md-12">
				                          <div class="panel panel-warning" >
				                           <div class="panel-heading" style="padding:17px;"> <h3 class="panel-title"> Battery(volts)  </h3></div>  
				                           <div class="panel-body">
                                                  <div id='battery'><!-- Plotly temp chart will be drawn inside this DIV </div--></div>
				                            </div>
				                         </div>
				                      
				                     </div>
				                    
				                    
				                </div>
				                
                            <!-- /.container-fluid -->
                        </section>
                        <!-- /.section -->

                    </div>
                    <!-- /.main-page -->

                    
                </div>
                <!-- /.content-container -->
            </div>
            <!-- /.content-wrapper -->

        </div>
        <!-- /.main-wrapper -->

        <!-- ========== COMMON JS FILES ========== -->
        <script src="js/jquery/jquery-2.2.4.min.js"></script>
        <script src="js/jquery-ui/jquery-ui.min.js"></script>
        <script src="js/bootstrap/bootstrap.min.js"></script>
        <script src="js/pace/pace.min.js"></script>
        <script src="js/lobipanel/lobipanel.min.js"></script>
        <script src="js/iscroll/iscroll.js"></script>

	<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
	<!--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.0/js/all.min.js"></script>-->
        <!-- ========== PAGE JS FILES ========== -->
        <script src="js/prism/prism.js"></script>
     
      
      
        <script src="js/toastr/toastr.min.js"></script>
        <script src="js/icheck/icheck.min.js"></script>
        <script src="https://cdn.plot.ly/plotly-latest.min.js"></script>

        <!-- ========== THEME JS ========== -->
        <script src="js/main.js"></script>
        <!--<script src="js/production-chart.js"></script>-->
        <!--<script src="js/traffic-chart.js"></script>-->
        <!--<script src="js/task-list.js"></script>-->
        <script>
            //$(function(){
	    $(document).ready(function(){
		var stTime = moment().subtract({'days': 365}).format('YYYY-MM-DD hh:mm:ss')
		var enTime = moment().add({'days': 1}).format('YYYY-MM-DD hh:mm:ss')
		var mPlot = document.getElementById('temp')
		//console.log(mPlot);
		localStorage.setItem("filter", false);

		function testFilter(){
			//console.log("Testing...")
			var filter = localStorage.getItem("filter");
			console.log("Testing...", filter);
			if(filter == "false"){
			    console.log("Calling...", filter);
			    applyFilter(stTime, enTime);
			}
		}
		
		$( "#showlive" ).click(function() {
		    console.log("Now Live")
            localStorage.setItem("filter", false);
            applyFilter(stTime, enTime);
            
        });
        
     
        
		(function worker() {
		    applyFilter()
		    setTimeout(worker, 60000);
		})();

		applyFilter(stTime, enTime);
		//var simple = '<?php echo $results1; ?>';
		//var awsData = <?php echo json_encode($results1); ?>;
		//console.log("results", awsData)

                // Welcome notification
                toastr.options = {
                  "closeButton": true,
                  "debug": false,
                  "newestOnTop": false,
                  "progressBar": false,
                  "positionClass": "toast-top-right",
                  "preventDuplicates": false,
                  "onclick": null,
                  "showDuration": "300",
                  "hideDuration": "1000",
                  "timeOut": "5000",
                  "extendedTimeOut": "1000",
                  "showEasing": "swing",
                  "hideEasing": "linear",
                  "showMethod": "fadeIn",
                  "hideMethod": "fadeOut"
                }
                toastr["success"]( "Welcome to Automatic Weather Station System!");


	    function applyFilter(start, end) {
		//console.log("applying filter", start, end)
		if (start === '' && end === '') {
			start = moment().subtract({'hours': 1})
			end = moment()
		}
		
		$.ajax({                                                                                                             	
                   type: "GET",
                   url: 'latestFilter.php',
                   async:false,
                //   data: {start: start, end: end },
                   success: function(res)
                   {
                      //console.log('res is ', JSON.parse(res));
                	sensData = JSON.parse(res);
                                                                                                                                      
                      //parseData(resParse)
                                                                                                                                      
                      var TempMinMax = [];
                      var TempAvg = [];
                      var TempMax = [];
                      var TempMin = [];
                      var TextData = [];
                      
                      var RainAvg = [];
                      var RainMin = [];
                      var RainMax = [];
                      var RainMinMax = [];
                      var TextRain = [];
                      
                      var RHAvg = [];
                      var RHMin = [];
                      var RHMax = [];
                      
                      var RHMinMax = [];
                      var TextRH = [];
                      
                      var BPAvg = [];
                      var BPMin = [];
                      var BPMax = []
                      var BPMinMax = [];
                      var TextBP = [];
                      
                      var SolarAvg = [];
                      var SolarMin = [];
                      var SolarMax = []
                      var SolarMinMax = [];
                      var TextSolar = [];
                      
                      var WSAvg = [];
                      var WSMin = [];
                      var WSMax = [];
                      var WSMinMax = [];
                      var TextWS = [];
                      var WD = []
                      var timestamp = [];
                      var Battery = [];
                      //$('.lastupdated').empty();
                      //$('.lastupdated').html(sensData[sensData.length - 1]["CreationDate"]);
                      
                      $('#avg').empty();
                      $('#pavg').html(sensData[0]["RAINavg"]);
                      
                      $('#volts').empty();
                      $('#volts').html(sensData[0]["Battery"]);
                      
                    //   $('#min').empty();
                    //   $('#min').html("Min: " + sensData[0]["RAINmin"].toString());
                      
                    //   $('#max').empty();
                    //   $('#max').html( "Max: " + sensData[0]["RAINmax"].toString());
                                                                                        
                      $('#time').empty();
                      $('#time').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString()); 
                      
                       $('#wd').empty();
                      $('#wd').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString()); 
                      
                      $('#wdtime').empty();
                      $('#wdtime').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString()); 
                      
                         
                      $('#battr').empty();
                      $('#battr').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString()); 
                      
                      
                       $('#savg').empty();
                      $('#savg').html(sensData[0]["SOLARavg"]);
                      $('#wdavg').html(sensData[0]["WD"]);
                      
                    //   $('#smin').empty();
                    //   $('#smin').html("Min: " + sensData[0]["SOLARmin"].toString());
                      
                    //   $('#smax').empty();
                    //   $('#smax').html( "Max: " + sensData[0]["SOLARmax"].toString());
                                                                                        
                      $('#stime').empty();
                      $('#stime').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString());                                              
                                
                      $('#wsstime').empty();
                      $('#wsstime').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString());                                              
                                                                                               
                                                                                                   
                      $('#bpavg').empty();
                      $('#bpavg').html(sensData[0]["BPavg"]);
                      
                    //   $('#bpmin').empty();
                    //   $('#bpmin').html("Min: " + sensData[0]["BPmin"].toString());
                      
                    //   $('#bpmax').empty();
                    //   $('#bpmax').html( "Max: " + sensData[0]["BPmax"].toString());
                                                                                        
                      $('#bptime').empty();
                      $('#bptime').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString());                                              
                                                                                                   
                                                                                                   
                                                                                                   
                     $('#tavg').empty();
                      $('#tavg').html(sensData[0]["TMPavg"]);
                      
                      $('#tmin').empty();
                      $('#tmin').html("Min: " + sensData[0]["TMPmin"].toString());
                      
                      $('#tmax').empty();
                      $('#tmax').html( "Max: " + sensData[0]["TMPmax"].toString());
                                                                                        
                      $('#ttime').empty();
                      $('#ttime').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString());                                              
                                                                                                   
                                                                                                   
                                                                                                   
                      $('#rhavg').empty();
                      $('#rhavg').html(sensData[0]["RHavg"]);
                      
                      $('#rhmin').empty();
                      $('#rhmin').html("Min: " + sensData[0]["RHmin"].toString());
                      
                      $('#rhmax').empty();
                      $('#rhmax').html( "Max: " + sensData[0]["RHmax"].toString());
                                                                                        
                      $('#rhtime').empty();
                      $('#rhtime').html( '<i class="fa fa-clock-o"></i>' + sensData[0]["CreationDate"].toString());     
                      
                      
                     $('#wsavg').empty();
                      $('#wsavg').html(sensData[0]["WSavg"]);
                      
                      $('#wsmin').empty();
                      $('#wsmin').html("Min: " + sensData[0]["WSmin"].toString());
                      
                      $('#wsmax').empty();
                      $('#wsmax').html( "Max: " + sensData[0]["WSmax"].toString());
                                                                                        
                      $('#wstime').empty();
                      $('#wstime').html( '<i class="fa fa-clock-o"></i> ' + sensData[0]["CreationDate"].toString());   
                                                                                                   
                                                                                                                                      
                      for (let i = sensData.length-1; i >= 0; i--) {  			
                      	//Temp Data
                      	//console.log("Data is ", sensData[i])
                      	a = {"max": sensData[i]["TMPmax"], "min": sensData[i]["TMPmin"]}
                      	TempMinMax[i] = a;
                      	TempAvg[i] = sensData[i]["TMPavg"];
                      	TempMin[i] = sensData[i]["TMPmin"];
                      	TempMax[i] = sensData[i]["TMPmax"]
                                                                                                   
                      	//b = {"max": sensData[i]["RAINmax"], "min": sensData[i]["RAINmin"]}
                      	RainAvg[i] = sensData[i]["RAINavg"]
                    //   	RainMin[i] = sensData[i]["RAINmin"];
                    //   	RainMax[i] = sensData[i]["RAINmax"]
                    //   	RainMinMax[i] = b
                                                                                                   
                      	//c = {"max": sensData[i]["BPmax"], "min": sensData[i]["BPmin"]}
                      	BPAvg[i] = sensData[i]["BPavg"]
                    //   	BPMin[i] = sensData[i]["BPmin"]
                    //   	BPMax[i] = sensData[i]["BPmax"]
                      	// BPMinMax[i] = c
                                                                                                   
                      	d = {"max": sensData[i]["RHmax"], "min": sensData[i]["RHmin"]}
                      	RHAvg[i] = sensData[i]["RHavg"]
                      	RHMin[i] = sensData[i]["RHmin"]
                      	RHMax[i] = sensData[i]["RHmax"]
                      	RHMinMax[i] = d
                                                                                                   
                      	//e = {"max": sensData[i]["SOLARmax"], "min": sensData[i]["SOLARmin"]}
                      	SolarAvg[i] = sensData[i]["SOLARavg"]
                      	//SolarMin[i] = sensData[i]["SOLARmin"]
                      	//SolarMax[i] = sensData[i]["SOLARmax"]
                      	//SolarMinMax[i] = e
                                                                                                   
                      	f = {"max": sensData[i]["WSmax"], "min": sensData[i]["WSmin"]}
                      	WSAvg[i] = sensData[i]["WSavg"];
                      	WSMin[i] = sensData[i]["WSmin"];
                      	WSMax[i] = sensData[i]["WSmax"];
                      	Battery[i] = sensData[i]["Battery"];
                      	WSMinMax[i] = f
                      	
                      	WD[i] = sensData[i]["WD"];
                                                                                                   
                      	timestamp[i] =  sensData[i]["CreationDate"]
                      }
                               
                    // console.log("Temp data", TempAvg, RHAvg, BPAvg, SolarAvg, WSAvg, RainAvg, TempMin)                                                                                                                  
                                                                                                                                      
                //       for (let i = 0; i < TempAvg.length; i++) { 
                //       	TextData[i] = "Max: " + TempMin[i]["max"].toString() + " Min: " + TempMin[i]["min"].toString()
                //       }
                //       for (let i = 0; i < RainAvg.length; i++) { 
                //       	TextRain[i] = "Max: " + RainMinMax[i]["max"].toString() + " Min: " + RainMinMax[i]["min"].toString()
                //       }
                //       for (let i = 0; i < RHAvg.length; i++) { 
                //       	TextRH[i] = "Max: " + RHMinMax[i]["max"].toString() + " Min: " + RHMinMax[i]["min"].toString()
                //       }
	               //   for (let i = 0; i < SolarAvg.length; i++) { 
                //       	TextSolar[i] = "Max: " + SolarMinMax[i]["max"].toString() + " Min: " + SolarMinMax[i]["min"].toString()
                //       }
                //       for (let i = 0; i < BPAvg.length; i++) { 
                //       	TextBP[i] = "Max: " + BPMinMax[i]["max"].toString() + " Min: " + BPMinMax[i]["min"].toString()
                //       }
                //       for (let i = 0; i < WSAvg.length; i++) { 
                //       	TextWS[i] = "Max: " + WSMinMax[i]["max"].toString() + " Min: " + WSMinMax[i]["min"].toString()
                //       }
                      
                      //console.log("temp data::", WD)	
                     
                                                                                                                                      
                      var WSAvg2 = {
                        //r: RHAvg,
                        y : WSAvg,     
                        x : timestamp,
                       // theta: ["North"],
                        name: "Wind Avg",
                        //marker: {color: "#FFF"},
                        //type: "barpolar"
                        //line: {color: "blue"}, 
                        
                        mode: 'lines+markers',
                        //mode: 'lines',
                        
                        type: 'scatter'
                       
                      }
                      
                       var WSMin2 = {
                        //r: RHAvg,
                        y : WSMin,   
                         x : timestamp,
                       // theta: ["North"],
                        name: "Wind Min",
                        //marker: {color: "#FFF"},
                        //type: "barpolar"
                        
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                        var WSMax2 = {
                        //r: RHAvg,
                        y : WSMax,     
                        x : timestamp,
                       // theta: ["North"],
                        name: "Wind Max",
                        //marker: {color: "#FFF"},
                        //type: "barpolar"
                        
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                      
                      
                     
                     
                      
                    var layout = {
                        title: "Wind Speed ",
                        showlegend: false,
                        xaxis: {
                            title: 'TIME'
                        },
                        yaxis: {
                            title: 'WS AVG/MIN/MAX',
                        },
                    }
                      var data = [WSAvg2, WSMin2, WSMax2];
                      //console.log('mplot', mPlot);
                      var config = {responsive: true}
                      
                      Plotly.newPlot('wind', data, layout, config);
                                                                                                                                      
  
                   
                   ///RAIN
                   
                    var RainAvg2 = {
                        y : RainAvg, 
                         x : timestamp,
                        name: "RAIN",
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                    //var RainMin2 = {
                    //     y : RainMin,                   
                    //     name: "Rain Min",
                    //     mode: 'lines+markers',
                    //     type: 'scatter'
                    //   }
                      
                    // var RainMax2 = {
                    //     y : RainMax,                   
                    //     name: "RAIN Max",
                    //     mode: 'lines+markers',
                    //     type: 'scatter'
                    // }
                      
                    var layout = {
                        title: "Rain Distribution",
                        showlegend: false,
                        xaxis: {
                            title: 'TIME'
                        },
                        yaxis: {
                            title: 'RAIN DISTRIBUTION',
                        },
                    }
                    var data = [RainAvg2];
                    var config = {responsive: true}
                    Plotly.newPlot('rain', data, layout, config);
                    //RAIN END
                    
                    ///Solar
                    var SolarAvg2 = {
                        y : SolarAvg,  
                         x : timestamp,
                        name: "Solar Avg",
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                    // var SolarMin2 = {
                    //     y : SolarMin,                   
                    //     name: "Solar Min",
                    //     mode: 'lines+markers',
                    //     type: 'scatter'
                    //   }
                      
                    // var SolarMax2 = {
                    //     y : SolarMax,                   
                    //     name: "Solar Max",
                    //     mode: 'lines+markers',
                    //     type: 'scatter'
                    // }
                      
                    var layout = {
                        title: "Solar Distribution",
                        showlegend: false,
                            xaxis: {
                            title: 'TIME'
                        },
                        yaxis: {
                            title: 'SOLAR AVG',
                        },
                    }
                    var data = [SolarAvg2];
                    var config = {responsive: true}
                    Plotly.newPlot('solar', data, layout, config);
                    
                    ///Solar
                    
                    ///BP
                    
                    var BPAvg2 = {
                        y : BPAvg,     
                         x : timestamp,
                        name: "BP Avg",
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                    // var BPMin2 = {
                    //     y : BPMin,                   
                    //     name: "BP Min",
                    //     mode: 'lines+markers',
                    //     type: 'scatter'
                    //   }
                      
                    // var BPMax2 = {
                    //     y : BPMax,                   
                    //     name: "BP Max",
                    //     mode: 'lines+markers',
                    //     type: 'scatter'
                    // }
                      
                    var layout = {
                        title: "BP Distribution",
                        showlegend: false,
                            xaxis: {
                            title: 'TIME'
                        },
                        yaxis: {
                            title: 'BP AVG',
                        },
                    }
                    var data = [BPAvg2];
                    var config = {responsive: true}
                    Plotly.newPlot('bp', data, layout, config);
                    
                    ///BP
                    
                    
                    ///WD
                    
                     var WD2 = {
                        y : WD,        
                         x : timestamp,
                        name: "Wind Direction",
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                  
                      
                    var layout = {
                        title: "Wind Direction",
                        showlegend: false,
                            xaxis: {
                            title: 'TIME'
                        },
                        yaxis: {
                            title: 'Wind Direction',
                        },
                    }
                    var data = [WD2];
                    var config = {responsive: true}
                    Plotly.newPlot('wdir', data, layout, config);
                    
                    
                    
                    ///WD
                    
                    ///Temp
                    
                    var TempAvg2 = {
                        y : TempAvg,   
                         x : timestamp,
                        name: "Temp Avg",
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                    var TempMin2 = {
                        y : TempMin,   
                         x : timestamp,
                        name: "Temp Min",
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                    var TempMax2 = {
                        y : TempMax,   
                         x : timestamp,
                        name: "Temp Max",
                        mode: 'lines+markers',
                        type: 'scatter'
                    }
                      
                    var layout = {
                        title: "Temperature Distribution",
                        showlegend: false,
                            xaxis: {
                            title: 'TIME'
                        },
                        yaxis: {
                            title: 'TEMP MIN/MAX/AVG',
                        },
                    }
                    var data = [TempAvg2, TempMin2, TempMax2];
                    var config = {responsive: true}
                    Plotly.newPlot('temp', data, layout, config);
                    
                    ///Temp
                    
                    ///Humid
                    
                    var RHAvg2 = {
                        y : RHAvg,     
                         x : timestamp,
                        name: "RH Avg",
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                    var RHMin2 = {
                        y : RHMin,     
                         x : timestamp,
                        name: "RH Min",
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                    var RHMax2 = {
                        y : RHMax,     
                         x : timestamp,
                        name: "RH Max",
                        mode: 'lines+markers',
                        type: 'scatter'
                    }
                      
                    var layout = {
                        title: "Humidity Distribution",
                        showlegend: false,
                            xaxis: {
                            title: 'TIME'
                        },
                        yaxis: {
                            title: 'Humidity AVG/MIN/MAX',
                        },
                    }
                    var data = [RHAvg2, RHMin2, RHMax2];
                    var config = {responsive: true}
                    Plotly.newPlot('humid', data, layout, config);
                    
                    ///Battery
                      var BatteryG = {
                        //r: RHAvg,
                        y : Battery,  
                        x : timestamp,
                      // theta: ["North"],
                        name: "Battery",
                        //marker: {color: "#FFF"},
                        //type: "barpolar"
                        
                        mode: 'lines+markers',
                        type: 'scatter'
                      }
                      
                       var layout = {
                        title: "Battery",
                         showlegend: false,
                              xaxis: {
                            title: 'TIME'
                        },
                        yaxis: {
                            title: 'BATTERY',
                        },
                   
                    }
                      var data = [BatteryG];
                      //console.log('mplot', mPlot);
                      var config = {responsive: true}
                      
                      Plotly.newPlot('battery', data, layout, config);
                    
                    
                    
                 },
                 error: function() {
                        console.log("unsuccessful");
                }                                                                                                                         
                   
            });
                
	    }
	    //var mPlot = document.getElementById('temp')
	   // console.log('mplot', mPlot);
	    mPlot.on('plotly_legendclick', function(data){
	        //console.log('mplot', mPlot);
	        localStorage.setItem("filter", true);

	    })
	    mPlot.on('plotly_legenddoubleclick', function(data){
	        //console.log('mplot d click', mPlot);
	        localStorage.setItem("filter", true);
	        
	    });

// [layerslider id="2"]
	    
	    var start = moment().subtract(29, 'days');
	    var end = moment();
	    
	    function cb(start, end) {
	        $('#reportrange span').html(start.format('MMMM D, YYYY hh:mm A') + ' - ' + end.format('MMMM D, YYYY hh:mm A'));
	    }
	    
	    $('#reportrange').daterangepicker({
	        timePicker: true,
	        startDate: start,
	        endDate: end,
	        locale: {
	           format: 'M/DD hh:mm A'
	        },
	        ranges: {
	           'Today': [moment(), moment()],
	           'Last 1 hour': [moment().subtract({'hours': 1}), moment()],
	           'Last 24 hour': [moment().subtract({'hours': 25}), moment()],
	           'Last 12 hour': [moment().subtract({'hours': 13}), moment()],

	    //       'Last 7 Days': [moment().subtract(6, 'days'), moment()],
	     //      'Last 30 Days': [moment().subtract(29, 'days'), moment()],
	      //     'This Month': [moment().startOf('month'), moment().endOf('month')],
	        //   'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
	        }
	    }, cb);
	    
	    cb(start, end);
	    
	    var mself = this
	    $('#reportrange').on('apply.daterangepicker', function(ev, picker) {
		  //console.log(picker.startDate.format('YYYY-MM-DD hh:mm:ss'));
		  //console.log(picker.endDate.format('YYYY-MM-DD hh:mm:ss'));
		  var start = picker.startDate.format('YYYY-MM-DD hh:mm:ss')
		  var end = picker.endDate.format('YYYY-MM-DD hh:mm:ss')
		  localStorage.setItem("filter", true);

		  applyFilter(start, end) 

	    });
	  
	    
	    
          });

        </script>
    </body>
</html>
<?php } ?>
